#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import os
import argparse
import sys
import pandas as pd
import plotly.graph_objects as go
import matplotlib.pyplot as plt
# import scipy



def contigstats_plot(df, meter, out , meterbis = None ):
    print(df)
    number_of_sample = df.shape[0]
    display = []
    display.append(go.Bar(x = df["ID"], y = df[meter], name=meter))
    if meterbis is not None:
        display.append(go.Bar(x = df["ID"], y = df[meterbis], name=meterbis))
    # fig = go.Figure(data=display)
    fig = go.Figure()
    
    fig.add_trace

    plt.show()


    if number_of_sample > 200:
        filename=os.path.join(out+"_"+meter+".png")
        print(filename)
        fig.write_image(filename)
    else:
        filename=os.path.join(out+"_"+meter+".html")
        print(filename)
        fig.write_html(filename)
    #return fig

def main():
    try:
        input = snakemake.input
    except NameError:
        # parsing script arguments
        parser = argparse.ArgumentParser(
            prog='metacovest',
            description='Estimate coverage depth and breadth from indexed '
            'BAM file and filter reference assembly.')
        parser.add_argument(
            'infile', type=str,
            help='input indexed BAM file')
        parser.add_argument(
            '--out', type=str,
            default="plot",
            help='prefix')
        parser.add_argument(
            '--filtered', action="store_true",
            default=False,
            help='')
        args = parser.parse_args()

        input = args.infile
        filtered = args.filtered
        out = args.out



    df = pd.read_csv(input,sep="\t",header=0,index_col=None)#,index_col=0)
    

    if not filtered:
        contigstats_plot(df, "total_length",out)
        contigstats_plot(df, "n_contigs",out)
        contigstats_plot(df, "n_longcontigs",out)
        contigstats_plot(df, "n_verylongcontigs",out)
        contigstats_plot(df, "N50",out)
        contigstats_plot(df, "L50",out)
    else:
        contigstats_plot(df, "total_length",out,"post_filter_total_length")
        contigstats_plot(df, "n_contigs",out,"post_filter_n_contigs")
        contigstats_plot(df, "n_longcontigs",out,"post_filter_n_longcontigs")
        contigstats_plot(df, "n_verylongcontigs",out,"post_filter_n_verylongcontigs")
        contigstats_plot(df, "N50",out,"post_filter_N50")
        contigstats_plot(df, "L50",out,"post_filter_L50")



if __name__ == "__main__":
    main()