from setuptools import setup

from os import path

this_directory = path.abspath(path.dirname(__file__))

print(this_directory)

with open(path.join(this_directory, 'README.md'), encoding='utf-8') as f:
    long_description = f.read()

setup(
    name = 'magneto',
    version = '1.4',
    long_description = long_description,
    long_description_content_type = 'text/markdown',
    packages = ["magneto"],
    package_data = {'': ["magneto"]},
    install_requires = ["click", "pyyaml", "snakemake", "pandas"],
    #,"sklearn","matplotlib","scipy","pandas"],
    data_files = [(".", ["README.md"])],
    include_package_data = True,
    entry_points ={
        'console_scripts': [
            'magneto = magneto.magneto:cli',
        ],
    }
)
