### Overview

**Developmental version of MSC**: This github page contains developmental version of R package for Multi-scale clustering (MSC) to perform single-cell transcriptome clustering. The manuscript is currently under review.

### Installation:
MEGENA needs to be installed, prior to MSC installation: 
library(devtools);
install_github("songw01/MEGENA");

For installation for developmental github version:  
library(devtools);  
install_github("songlabcodes/MSC");

**Vignettes**  
[PBMC 8k example](http://htmlpreview.github.io/?https://github.com/songlabcodes/MSC/blob/main/vignettes/8k_PBMC_Example.html): This contains the overall MSC workflow from data pre-processing, clustering, marker identification to visualization of the results.

[pipeComp vignettes](http://htmlpreview.github.io/?https://github.com/songlabcodes/MSC/blob/main/vignettes/pipeComp_workflow.html): Comparative analysis of MSC performance with other benchmark clustering methods using pipeComp data sets with gold standard ground-truth clusters. Reproduces Figure 4 of manuscript.

[Ding et al. 2020 vignettes](http://htmlpreview.github.io/?https://github.com/songlabcodes/MSC/blob/main/vignettes/Ding_et_al_2020_workflow.html): Comparative analysis of MSC performance with other benchmark clustering methods using pipeComp data sets with gold standard ground-truth clusters. Reproduces Figure 5 of manuscript.

[Lee et al. 2020 vignette](http://htmlpreview.github.io/?https://github.com/songlabcodes/MSC/blob/main/vignettes/Lee_et_al_2020_workflow.html): Codes to reproduce MSC analysis of influenza/COVID-19 infected PMBC scRNA-seq from Lee et al. 2020.

[Wu et al. 2021 vignette](http://htmlpreview.github.io/?https://github.com/songlabcodes/MSC/blob/main/vignettes/Wu_et_al_2021_workflow.html): Codes to reproduce MSC analysis of breast cancer single-cell atlas from Wu et al. 2021.

**Disclaimer**: Data files for examples (pbmc_8k_msc_results.rda, simMix1.rda) are distributed under the CC0 1.0 Universal (CC0 1.0) Public Domain Dedication (https://creativecommons.org/publicdomain/zero/1.0/). Otherwise, the codes are distrubuted under GPL-3.0 license as creative works. 
