% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.v1.R
\name{calculate_jaccard}
\alias{calculate_jaccard}
\title{Jaccard Index Calculation}
\usage{
calculate_jaccard(mod.o, mod.f)
}
\arguments{
\item{mod.o}{A list containing different reference sets.}

\item{mod.f}{A list containing different test sets.}
}
\value{
a matrix, where ith row and jth column contains the Jaccard index for ith set in mod.o and jth set in mod.f.
}
\description{
Calculate the Jaccard Index, as the ratio between intersection and union of two sets.
}
\examples{
mod.o = list(set1 = LETTERS[1:10])
mod.f = list(set1 = LETTERS[5:20])
calculate_jaccard(mod.o,mod.f)
}
