% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.v1.R
\name{clusterwise_DE_analysis}
\alias{clusterwise_DE_analysis}
\title{Pseudo-bulk based clusterwise differential analysis}
\usage{
clusterwise_DE_analysis(
  seu,
  modules,
  sam.name,
  case.id,
  ctrl.id,
  col.name,
  assay.name = "RNA",
  fc.cut = 2,
  pval.cut = 0.05,
  n.cores = 8
)
}
\arguments{
\item{seu}{Seurat object.}

\item{modules}{A list object holding the list of cell names as a character vector in each element}

\item{sam.name}{A character value. Specify the column name in the Seurat object metadata, holding the sample assignments of individual cells.}

\item{case.id}{A character value. Specify the name for the case group.}

\item{ctrl.id}{A character value. Specify the name for the control group.}

\item{col.name}{A character value. Specify the column name in the Seurat object metadata, holding case/control group assignments of individual cells.}

\item{assay.name}{A character value. Specify tje assay name to use in the Seurat object.}

\item{fc.cut}{A numeric. Expression fold change cutoff for significance threshold.}

\item{pval.cut}{A numeric. FDR cutoff for significance threshold.}

\item{n.cores}{A numeric. Number of cores to run the parallelized routine.}
}
\value{
a data.frame containing the .
}
\description{
Calculates differentially expressed genes (DEGs) per cell cluster by generating pseudobulk data, followed by DESeq2.
}
\examples{
# See vignette.
}
