% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LENA_functions.v5.20.R
\name{generate_cell_network.wt.loess}
\alias{generate_cell_network.wt.loess}
\title{Perform locally embedded network (LEN) to calculate cell-cell similarity network}
\usage{
generate_cell_network.wt.loess(
  mat,
  bcnt,
  dist.func,
  is.decreasing,
  n.cores = 8
)
}
\arguments{
\item{mat}{A log-normalized single-cell expression matrix (rows: genes, columns: cell).}

\item{bcnt}{A binary matrix of genes (row) by cells (column). If expressed, \code{bcnt[i,j] = 1}, otherwise 0.}

\item{dist.func}{A function to calculate cell-cell similarity/dissimilarity.}

\item{is.decreasing}{A logical. TRUE if dist.func is similarity function to show greater value corresponds to greater similarity. FALSE if dist.func is dissimilarity.}

\item{n.cores}{An integer for the number of cores for parallelization}
}
\value{
A list containing the MSC results
\describe{
\item{modules}{A list of cell clusters}
\item{module.table}{A data.frame containing cell cluster statistics (sizes, compactness, intra-cluster connectivity etc).}
\item{cell.network}{An igraph object containing the cell network}
\item{alpha.value}{The alpha parameter value used to calculate the cluster compactness}
\item{pruned.table}{Refined list of cell clusters after applying compactness and/or intra-cluster connectivity filters.}
}
}
\description{
Perform locally embedded network (LEN) to calculate cell-cell similarity network.
}
\examples{
\donttest{
data(simMix1)

library(scater)
library(scran)
library(doParallel)
qc.out = process_data(simMix1,do.impute = TRUE)

# add reduced dim
reducedDim(qc.out$sce,"PCA.imputed") = calculatePCA(x = assay(qc.out$sce,"ALRA.logcounts"),
subset_row = rownames(subset(qc.out$gene.data.alra,p.value < 0.05)))
reducedDim(qc.out$sce,"UMAP.imputed") = calculateUMAP(x = qc.out$sce,dimred = "PCA.imputed")
reducedDim(qc.out$sce,"tSNE.imputed") = calculateTSNE(x = qc.out$sce,dimred = "PCA.imputed")

plotReducedDim(qc.out$sce,dimred = "tSNE.imputed",colour_by = "phenoid")
# for imputed data for correlation computation 
dat = subset(qc.out$gene.data.alra,bio > 0 & p.value < 0.05)
bcnt.alra = counts(qc.out$sce)[rownames(dat),]
m.alra = as.matrix(assay(qc.out$sce,"ALRA.logcounts")[rownames(dat),])
bcnt.alra[bcnt.alra > 1E-320] = 1
g.len = generate_cell_network.wt.loess(mat = m.alra,bcnt = bcnt.alra,
dist.func = function(a, b) cor(a,b,method ="pearson"),
is.decreasing = TRUE,n.cores = 2)
}
}
