% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_functions.v3.R
\name{get_rooted_membership}
\alias{get_rooted_membership}
\title{Get child cluster membership vector}
\usage{
get_rooted_membership(mtbl, modules, pid, bg)
}
\arguments{
\item{mtbl}{A data.frame object, for the cluster information table. Can be obtained from module.table or pruned.table slot in output from \code{\link[=iterative_clustering.par]{iterative_clustering.par()}}.}

\item{modules}{A named list object. Each is the character vector of cells from a cell cluster.}

\item{pid}{A character value for the parent cluster. The respective child cluster will be identified from mtbl.}

\item{bg}{A character vector containing the full list of cell names.}
}
\value{
Returns a named vector of cluster membership.
}
\description{
Anchored onto a parent cluster, child cluster membership vector is calculated
}
\examples{
data(pbmc_8k_msc_results)
library(igraph)
mem.vec = get_rooted_membership(mtbl = pbmc_8k_msc_results$pruned.table,
modules = pbmc_8k_msc_results$modules,pid = "M2",bg = V(pbmc_8k_msc_results$cell.network)$name)
table(mem.vec)
}
