% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.v3.7.R
\docType{package}
\name{iterative_clustering}
\alias{iterative_clustering}
\title{Iterative top-down clustering workflow}
\usage{
iterative_clustering(
  g.in,
  min.size = 10,
  d.func = function(x) sqrt(2 * (1 - x)),
  alpha = 1,
  pcut = 0.05,
  valid.gate = "both",
  seed = 1234
)
}
\arguments{
\item{g.in}{An igraph object containing the network}

\item{min.size}{An integer. The minumum cluster size threshold.}

\item{d.func}{a function to convert the edge weights into edge function. Default is d(x) = sqrt(2*(1-x)), the metric distance for correlation coefficient.}

\item{alpha}{The alpha exponent for compactness calculation. Can be obtained from identify_scale_parameter().}

\item{pcut}{A numeric. The p-value to identify clusters with significantly high intra-cluster connectivity. Default is 0.05.}

\item{valid.gate}{Filtering method to identify significant clusters. "density" compares intra-cluster link density between parent and child clusters. "compact" compared compactness with the parent clusters. "both" uses "density" and "compact" filters simultaneously. Default is "both".}

\item{seed}{Seed value to initialize the random sampling. Default is 1234.}
}
\value{
Returns a numeric value for the alpha value.
}
\description{
Given input cell network, performs the iterative clustering to probe the multi-scale structure.
}
\examples{
\donttest{
data(pbmc_8k_msc_results)
alpha.val = identify_scale_parameter(pbmc_8k_msc_results$cell.network,mode = "diameter")
iter.res = iterative_clustering(g.in = pbmc_8k_msc_results$cell.network,alpha = alpha.val)
}
}
\seealso{
\code{\link[=identify_scale_parameter]{identify_scale_parameter()}}
}
