% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.v3.7.R
\docType{package}
\name{iterative_clustering.par}
\alias{iterative_clustering.par}
\title{Parallelized, iterative top-down clustering workflow}
\usage{
iterative_clustering.par(
  g.in,
  min.size = 10,
  d.func = function(x) sqrt(2 * (1 - x)),
  alpha = 1,
  pcut = 0.05,
  seed = 1234,
  valid.gate = "both",
  n.cores = 2
)
}
\arguments{
\item{g.in}{An igraph object containing the network}

\item{min.size}{An integer. The minumum cluster size threshold.Default is 10.}

\item{d.func}{a function to convert the edge weights into edge function. Default is d(x) = sqrt(2*(1-x)), the metric distance for correlation coefficient.}

\item{alpha}{The alpha exponent for compactness calculation. Can be obtained from identify_scale_parameter().}

\item{pcut}{A numeric. The p-value to identify clusters with significantly high intra-cluster connectivity. Default is 0.05.}

\item{seed}{Seed value to initialize the random sampling. Default is 1234.}

\item{valid.gate}{Filtering method to identify significant clusters. "density" compares intra-cluster link density between parent and child clusters. "compact" compared compactness with the parent clusters. "both" uses "density" and "compact" filters simultaneously. Default is "both".}

\item{n.cores}{An integer for the number of cores for parallelization}
}
\value{
Returns a numeric value for the alpha value.
}
\description{
Given input cell network, performs the iterative clustering to probe the multi-scale structure with parallelization.
}
\examples{
\donttest{
data(pbmc_8k_msc_results)
alpha.val = identify_scale_parameter(pbmc_8k_msc_results$cell.network,mode = "diameter")
closeAllConnections()
iter.res = iterative_clustering.par(g.in = pbmc_8k_msc_results$cell.network,alpha = alpha.val,n.cores = 2)
}
}
\seealso{
\code{\link[=identify_scale_parameter]{identify_scale_parameter()}}
}
