% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_qc_functions.internal_v1.R
\name{load_mtx}
\alias{load_mtx}
\title{Load 10x-style count matrix}
\usage{
load_mtx(
  mtx.folder,
  mat.path = NULL,
  feat.path = NULL,
  bar.path = NULL,
  is.gzip = FALSE
)
}
\arguments{
\item{mtx.folder}{A character to specify folder name that holds the three files (matrix.mtx - count data, features.tsv - feature data, barcodes.tsv - cell barcode data). If NULL, specific file path name has to be specified in mat.path, feat.path and bar.path.}

\item{mat.path}{A character value. If mtx.folder is NULL, mat.path has to be specified for the matrix.mtx file.}

\item{feat.path}{A character value. If mtx.folder is NULL, feat.path has to be specified for the features.tsv file.}

\item{bar.path}{A character value. If mtx.folder is NULL, feat.path has to be specified for the barcodes.tsv file.}

\item{is.gzip}{A logical. If TRUE, the input files are understood as gzipped, and handled accordingly to open.}
}
\value{
Returns a list consisting of gene.matrix (sparse gene count matrix), gene.features (a data.frame containing feature annotation) and barcode.features (a data.frame containing barcode annotations).
}
\description{
Loads 10x count matrices.
}
