% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_functions.v3.R
\name{plot_dimred_manual.raw}
\alias{plot_dimred_manual.raw}
\title{Generate dimension reduction plot.}
\usage{
plot_dimred_manual.raw(
  xy,
  cell.feat,
  alpha.val = 0.1,
  cls.col = NULL,
  add.labels = TRUE,
  label.size = 5,
  is.repel = FALSE,
  is.root = NULL
)
}
\arguments{
\item{xy}{Two column matrix, where each row is the cartesian coordinate for a cell.}

\item{cell.feat}{A named factor vector for cell group assignments.}

\item{alpha.val}{A numeric from 0 to 1 to specific dot transparency.}

\item{cls.col}{A named character vector to specify colors for the groups in "cell.feat".}

\item{add.labels}{A logical. If TRUE, adds labels to the groups.}

\item{label.size}{If add.labels = TRUE, then label.size specifies the label font size in the plot.}

\item{is.repel}{A logical. If TRUE, uses \code{\link[=geom_text_repel]{geom_text_repel()}} from ggrepel package to add the labels.}

\item{is.root}{A logical vector. Each specify if each cell belongs to the parent cluster of interest.}
}
\value{
Returns a named vector of cluster membership.
}
\description{
Generated ggplot object to show 2-dimensional dimension reduction plot
}
\examples{
cell.names = letters[1:10]
xy =  matrix(runif(20,0,1),ncol = 2);rownames(xy) = cell.names
cell.feat= factor(c(rep("A",5),rep("B",5)));names(cell.feat) = cell.names
plot_dimred_manual.raw(xy,cell.feat,alpha.val = 1)
}
