% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_functions.v3.R
\name{plot_hierarchy_dot.raw}
\alias{plot_hierarchy_dot.raw}
\title{Hierarchical representation of marker dot plots}
\usage{
plot_hierarchy_dot.raw(
  m,
  cnts,
  htbl,
  modules,
  celltype.markers,
  pct.mark = 0.1,
  plot.hierarchy = TRUE,
  filename = "celltype_markers.hierarchy_dot.png",
  width.per.plot = 2500,
  height.per.plot = 3500
)
}
\arguments{
\item{m}{log-normalized gene expression matrix to calculate the average expression levels.}

\item{cnts}{count matrix to calculate the \%. of cells expressing genes.}

\item{htbl}{A two column data.frame table. The first column is cluster name, and the second column is its parent cluster name.}

\item{modules}{A named list object. Each is the character vector of cells from a cell cluster.}

\item{celltype.markers}{A named character vector for the list of genes to create the dotplot. The names specify cell type names.}

\item{pct.mark}{A numeric value < 1 as the proportion threshold of cells in a module to express a gene.}

\item{plot.hierarchy}{A logical. If FALSE, only marker statistics will be returned.}

\item{filename}{A character. If provided, a .png file will be outputed with the filename.}

\item{width.per.plot}{A numeric. The width per plot.}

\item{height.per.plot}{A numeric. The height per plot.}
}
\value{
a list of data.frame for the marker statistics, and list of ggplot objects holding the plots.
}
\description{
Create circular hierarchy tree to visualize dot plot for desired marker genes, and calculate the marker statistics for provided genes.
}
\examples{
# See Vignettes. 
}
