% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_functions.v3.R
\name{plot_hierarchy_pie}
\alias{plot_hierarchy_pie}
\title{Hierarchical representation of modules with piecharts}
\usage{
plot_hierarchy_pie(htbl, modules, vec, edge_colour = "black", colmap = NULL)
}
\arguments{
\item{htbl}{A two column data.frame table. The first column is cluster name, and the second column is its parent cluster name.}

\item{modules}{A named list object. Each is the character vector of cells from a cell cluster.}

\item{vec}{A factor vector, containing different groups of cells.}

\item{edge_colour}{edge colour of pie chart.}

\item{colmap}{a named vector to assign colors to each group in vec.}
}
\value{
a ggplot object
}
\description{
Create circular hierarchy tree to visualize the cluster hierarchy, with pie chart to show cell cluster composition
}
\examples{
data(pbmc_8k_msc_results)
htbl = pbmc_8k_msc_results$pruned.table[,c("cluster.name","parent.cluster")]
modules = pbmc_8k_msc_results$modules
bg = Reduce("union",modules)
vec = sample(LETTERS[1:10],length(bg),replace = TRUE);names(vec) = bg;vec = factor(vec)
obj = plot_hierarchy_pie(htbl,modules,vec)
}
