% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_qc_functions.internal_v1.R
\name{process_data}
\alias{process_data}
\title{Basic data processing with scra}
\usage{
process_data(sim, do.impute = FALSE)
}
\arguments{
\item{sim}{A SingleCellExperiment object with counts in it.}

\item{do.impute}{A logical. If TRUE, ALRA imputation is performed. Note that if data is big, the imputation takes time.}
}
\value{
Returns a list with processed SingleCellExperiment object, data.frame for gene statistics, then a vector for listing variable genes.
}
\description{
Use scran workflow to get variable genes, then use ALRA for imputation.
}
\examples{
\donttest{
data(simMix1)
library(scran)
library(scater)
qc.out = process_data(simMix1,do.impute = TRUE)

# add reduced dim
reducedDim(qc.out$sce,"PCA.imputed") = calculatePCA(x = assay(qc.out$sce,"ALRA.logcounts"),
subset_row = rownames(subset(qc.out$gene.data.alra,p.value < 0.05)))
reducedDim(qc.out$sce,"UMAP.imputed") = calculateUMAP(x = qc.out$sce,dimred = "PCA.imputed")
reducedDim(qc.out$sce,"tSNE.imputed") = calculateTSNE(x = qc.out$sce,dimred = "PCA.imputed")

plotReducedDim(qc.out$sce,dimred = "tSNE.imputed",colour_by = "phenoid")
}
}
