% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.v3.7.R
\docType{package}
\name{split_network}
\alias{split_network}
\title{Perform adaptive split of a network (AdaptSplit)}
\arguments{
\item{g}{An igraph object containing the network}

\item{mi}{An integer. The clusters will be indexed, starting from the integer specified by mi.}

\item{d.func}{a function to convert the edge weights into edge function.}

\item{alpha}{Compactness resolution parameter. This value is used to calculate the compactness of the child clusters obtained from the split.}

\item{node.perturb.prop}{Proportion of nodes to randomly shuffle to calculate the reference distribution of intra-cluster connectivity.}
}
\value{
Returns a list containing clustering results with optimal.modules (the final results from adapt split), resolution.tested (clustering resolution sweeped), resolution.used (the final value of clustering resolution), and module.table containing the compactness and intra-cluster connectivity stats.
}
\description{
Sweeps over the clustering resolution in \code{[0.1,2]} to find the most granular clustering results.
}
\examples{
data(pbmc_8k_msc_results)
split_network(g = pbmc_8k_msc_results$cell.network,mi = 0)
}
